/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8230.DeviceView;

import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8230.DeviceView.BuilderLike;
import ibm.nways.jdm8230.DeviceView.ChassisLike;
import ibm.nways.jdm8230.DeviceView.ChassisUnknown;
import ibm.nways.jdm8230.DeviceView.Factory;
import ibm.nways.jdm8230.DeviceView.FactoryLike;
import ibm.nways.jdm8230.DeviceView.ModuleLike;
import ibm.nways.jdm8230.DeviceView.PortLike;
import ibm.nways.jdm8230.DeviceView.PortRI_ROLike;
import ibm.nways.jdm8230.DeviceView.RLiuPortLike;
import ibm.nways.jdm8230.DeviceView.SpeedSwitchLike;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class Builder
implements BuilderLike {
    private static final Builder builderInstance = new Builder();
    private static FactoryLike factory = Factory.getInstance();

    private Builder() {
    }

    public static BuilderLike getInstance() {
        return builderInstance;
    }

    public ChassisLike buildChassis(JdmBrowser jdmBrowser) {
        ChassisLike chassisLike = null;
        Object object = null;
        Serializable serializable = null;
        try {
            GenModel genModel = (GenModel)jdmBrowser.getModel();
            ModelInfo modelInfo = genModel.getInfo("Config");
            object = modelInfo.get("Config.SysObjectID");
            serializable = modelInfo.get("Config.CauProdDataMachineType");
        }
        catch (Exception exception) {
            RAS.logException(19, 4, this, "getInstance", exception);
        }
        if (!object.toString().equals("Timeout") && !((chassisLike = factory.createChassis((Serializable)object, serializable)) instanceof ChassisUnknown)) {
            chassisLike.setJdmBrowser(jdmBrowser);
            chassisLike.discoverChildren();
        }
        return chassisLike;
    }

    public ModuleLike buildModule(ChassisLike chassisLike, JdmBrowser jdmBrowser, GenModel genModel, GenModel genModel2, int n, int n2, int n3, GraphicContainer graphicContainer, int n4) {
        ModuleLike moduleLike = factory.createModule(n2, n3, n4);
        moduleLike.setCommonInformation(chassisLike, jdmBrowser, genModel, genModel2, n, graphicContainer);
        moduleLike.setSpecificInformation();
        moduleLike.discoverChildren();
        return moduleLike;
    }

    public ModuleLike buildRIRO(ChassisLike chassisLike, JdmBrowser jdmBrowser, GenModel genModel, GenModel genModel2, int n, int n2, int n3, int n4, GraphicContainer graphicContainer, int n5) {
        ModuleLike moduleLike = factory.createRIRO(n2, n3, n4, n5);
        moduleLike.setCommonInformation(chassisLike, jdmBrowser, genModel, genModel2, n, graphicContainer);
        moduleLike.setSpecificInformation();
        moduleLike.discoverChildren();
        return moduleLike;
    }

    public ModuleLike buildRLam(ChassisLike chassisLike, JdmBrowser jdmBrowser, GenModel genModel, GenModel genModel2, int n, int n2, GraphicContainer graphicContainer) {
        ModuleLike moduleLike = factory.createRLam(n2);
        moduleLike.setCommonInformation(chassisLike, jdmBrowser, genModel, genModel2, n, graphicContainer);
        moduleLike.setSpecificInformation();
        moduleLike.discoverChildren();
        return moduleLike;
    }

    public PortLike buildPort(ChassisLike chassisLike, JdmBrowser jdmBrowser, GenModel genModel, int n, String string, int n2, int n3, GraphicContainer graphicContainer) {
        PortLike portLike = factory.createPort(n3, n2, string);
        portLike.setCommonInformation(chassisLike, jdmBrowser, genModel, n, n2, graphicContainer);
        portLike.setSpecificInformation();
        return portLike;
    }

    public PortRI_ROLike buildRI_ROPort(ChassisLike chassisLike, JdmBrowser jdmBrowser, GenModel genModel, String string, int n, int n2, GraphicContainer graphicContainer) {
        PortRI_ROLike portRI_ROLike = factory.createRI_ROPort(n2, n, string);
        portRI_ROLike.setCommonInformation(chassisLike, jdmBrowser, genModel, n, n2, graphicContainer);
        portRI_ROLike.setSpecificInformation();
        return portRI_ROLike;
    }

    public RLiuPortLike buildRLiuPort(ChassisLike chassisLike, JdmBrowser jdmBrowser, GenModel genModel, int n, int n2, GraphicContainer graphicContainer) {
        RLiuPortLike rLiuPortLike = factory.createRLiuPort(n);
        rLiuPortLike.setCommonInformation(chassisLike, jdmBrowser, genModel, n2, graphicContainer);
        rLiuPortLike.setSpecificInformation();
        return rLiuPortLike;
    }

    public SpeedSwitchLike buildSpeedSwitch(ChassisLike chassisLike, JdmBrowser jdmBrowser, GraphicContainer graphicContainer, int n) {
        Object object;
        Integer n2 = new Integer(-1);
        GenModel genModel = (GenModel)jdmBrowser.getModel();
        try {
            genModel = (GenModel)genModel.getComponent("Interfaces");
            object = genModel.getNextInfo("Panel", "default", null);
            Serializable serializable = ((ModelInfo)object).get("Panel.IfSpeed");
            if (serializable instanceof Vector) {
                Vector vector = (Vector)serializable;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    n2 = new Integer(enumeration.nextElement().toString());
                }
            } else {
                n2 = new Integer(serializable.toString());
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 4, this, "builsSpeedSwitch", exception);
        }
        object = factory.createSpeedSwitch(n2, n);
        object.setCommonInformation(jdmBrowser, genModel, graphicContainer);
        return object;
    }
}

